﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using PpmsDataWebService.Models;
using PpmsDataWebService.ModelsEnumTypes;
using VA.PPMS.Context;
using Microsoft.Xrm.Client.Messages;
using Microsoft.Xrm.Sdk;
using Microsoft.Xrm.Sdk.Query;
using System.Diagnostics;
using Microsoft.Xrm.Sdk.Messages;

namespace PpmsDataWebService.Mappers
{
    public class QuickProviderMap
    {
        public static async Task<IQueryable<Provider>> MapProviders(List<Account> ppmsProviders,string queryType)
        {
            var providerList = new List<Provider> { };

            for (int i = 0; i < ppmsProviders.Count; i++)
            {
                var provider = new Provider
                {
                    ProviderIdentifier = Convert.ToInt64(ppmsProviders[i].ppms_ProviderIdentifier)
                };

                if (ppmsProviders[i].StatusCode != null)
                    switch (ppmsProviders[i].StatusCode.Value)
                    {
                        case (int)Account_StatusCode.Active:
                            provider.ProviderStatusReason = ProviderStatusReason.Active;
                            break;
                        case (int)Account_StatusCode.AddressValidation:
                            provider.ProviderStatusReason = ProviderStatusReason.AddressValidation;
                            break;
                        case (int)Account_StatusCode.Deactivated:
                            provider.ProviderStatusReason = ProviderStatusReason.Deactivated;
                            break;
                        case (int)Account_StatusCode.Hold:
                            provider.ProviderStatusReason = ProviderStatusReason.Hold;
                            break;
                        case (int)Account_StatusCode.Inactive:
                            provider.ProviderStatusReason = ProviderStatusReason.Inactive;
                            break;
                        case (int)Account_StatusCode.LEIEExclusion:
                            provider.ProviderStatusReason = ProviderStatusReason.LeieExclusion;
                            break;
                        case (int)Account_StatusCode.LicenseExpiration:
                            provider.ProviderStatusReason = ProviderStatusReason.LicenseExpiration;
                            break;
                        case (int)Account_StatusCode.NPICheckFailure:
                            provider.ProviderStatusReason = ProviderStatusReason.NpiCheckFailure;
                            break;
                        case (int)Account_StatusCode.PendingReview:
                            provider.ProviderStatusReason = ProviderStatusReason.PendingReview;
                            break;
                        case (int)Account_StatusCode.SAMSExclusion:
                            provider.ProviderStatusReason = ProviderStatusReason.SamsExclusion;
                            break;
                        case (int)Account_StatusCode.ValidationProcess:
                            provider.ProviderStatusReason = ProviderStatusReason.ValidationProcess;
                            break;
                    }

                providerList.Add(provider);
            }
            var providers = providerList.AsQueryable();
            return providers;

        }

    }
}